/*******************************************************************************
*                         USB4ALLAPI Library Version 1.0                       *
*******************************************************************************/
#ifndef _U4AAPI_H_
#define _U4AAPI_H_

#include "Conf.h"

class iCommandLayer;
class iHandlerLayer;
class log;

class _IMPEXP_USB4ALLAPI u4aapi {
    private:
        u4aapi();
        static u4aapi *instance;
        static u4aapi *getInstance();
        iCommandLayer *cl;
        iHandlerLayer *hl;
        log *l;
        ~u4aapi();
    public:
        int openDevice(int, char*, int, int);
        bool configDevice(int, char*, int);
        bool sendData(int, char*, int, int);
        bool receiveData(int, char*, int, int);
        bool closeDevice(int);
        int getBaseBoardSerial(int);
        int qtyBaseBoards();
        int getUserModuleName(int, int, char*);
        int qtyUserModules(int);
        void resetBaseBoard(int);
        void initAPI();
        int apiVersion();
        int firmwareVersion(int);
};

#endif
